/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.mediasvc;

import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.mediasvc.MediaDevice;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceException;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceIdentifier;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceLockException;
import com.ibm.hwmca.fw.mediasvc.MediaServicesErrorIds;
import com.ibm.hwmca.fw.mediasvc.NoMediaPresentException;
import com.ibm.hwmca.fw.util.RootProcess;
import com.ibm.hwmca.fw.util.Trace;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;

public class USBFlashDrive
extends MediaDevice {
    private String volumeLabel = null;

    USBFlashDrive(MediaDeviceIdentifier id) throws MediaDeviceException {
        super(id);
        Trace.trace("XMDADEVT", "-> USBFlashDrive.USBFlashDrive(MediaDeviceIdentifier = " + id + ")");
        this.mountWithUid = true;
        try {
            Trace.trace("XMDADEVF", "USBFlashDrive.USBFlashDrive(): Getting the volume label from within the USBFlashDrive constructor.");
            this.getLabel();
        }
        catch (MediaDeviceException mdexc) {
            Trace.trace("XMDADEVF", mdexc);
        }
        Trace.trace("XMDADEVT", "USBFlashDrive.USBFlashDrive()");
    }

    public void eject() throws MediaDeviceException, MediaDeviceLockException, UnsupportedOperationException {
        Trace.trace("XMDADEVT", "<> USBFlashDrive.eject()");
        throw new UnsupportedOperationException("The USB flash drive does not support media ejection.");
    }

    public void lockDriveDoor() throws MediaDeviceException, MediaDeviceLockException, UnsupportedOperationException {
        Trace.trace("XMDADEVT", "<> USBFlashDrive.lockDriveDoor()");
        throw new UnsupportedOperationException("The USB flash drive does not support drive door locking.");
    }

    public void unlockDriveDoor() throws MediaDeviceException, MediaDeviceLockException, UnsupportedOperationException {
        Trace.trace("XMDADEVT", "<> USBFlashDrive.unlockDriveDoor()");
        throw new UnsupportedOperationException("The USB flash drive does not support drive door unlocking.");
    }

    public void format(String label, int fileSystemType) throws MediaDeviceException, MediaDeviceLockException, NoMediaPresentException, IllegalArgumentException, UnsupportedOperationException {
        block7: {
            Trace.trace("XMDADEVT", "-> USBFlashDrive.format(label = " + label + ", " + "fileSystemType = " + fileSystemType + ")");
            if (!this.isLockValid()) {
                throw new MediaDeviceLockException("Operation attempted by task other than the device lock owner.", this.mediaDeviceIdentifier.getCurrentLockOwner());
            }
            if (fileSystemType == 1 || fileSystemType == 4 || fileSystemType == 5) {
                if (!this.isFormattable()) {
                    throw new UnsupportedOperationException("The media device does not support formatting.");
                }
                if (!this.isMediaPresent()) {
                    throw new NoMediaPresentException("missing media");
                }
                try {
                    String[] formatCmd = new String[]{this.mediaServicesParameters.getParm("media.usbmemformat.script"), this.mediaDeviceProperties.getDeviceFile(), new Integer(fileSystemType).toString(), this.mediaServicesParameters.getParm("media.log.dir") + this.mediaServicesParameters.getParm("media.log"), label};
                    Trace.trace("XMDADEVF", "USBFlashDrive.format(): formatCmd[0] = " + formatCmd[0]);
                    Trace.trace("XMDADEVF", "USBFlashDrive.format(): formatCmd[1] = " + formatCmd[1]);
                    Trace.trace("XMDADEVF", "USBFlashDrive.format(): formatCmd[2] = " + formatCmd[2]);
                    Trace.trace("XMDADEVF", "USBFlashDrive.format(): formatCmd[3] = " + formatCmd[3]);
                    Trace.trace("XMDADEVF", "USBFlashDrive.format(): formatCmd[4] = " + formatCmd[4]);
                    int rc = RootProcess.executeProgram(formatCmd);
                    Trace.trace("XMDADEVF", "USBFlashDrive.format(): rc = " + rc);
                    if (rc != 0) {
                        throw new IOException("USB flash memory drive format failed!");
                    }
                    break block7;
                }
                catch (Exception exc) {
                    Trace.trace("XMDADEVF", exc);
                    MediaDeviceException mdexc = new MediaDeviceException(exc);
                    new FrameworkLog(MediaServicesErrorIds._logInfo, 632, mdexc).log();
                    throw mdexc;
                }
            }
            Trace.trace("XMDADEVF", "USBFlashDrive.format(): The filesystem type " + fileSystemType + " is not a supported filesystem to format the USB flash memory drive.");
            throw new IllegalArgumentException("Invalid filesystem type specified to format USB flash memory drive.");
        }
        Trace.trace("XMDADEVT", "<- USBFlashDrive.format()");
    }

    public String getLabel() throws MediaDeviceException, MediaDeviceLockException, NoMediaPresentException {
        Trace.trace("XMDADEVT", "-> USBFlashDrive.getLabel()");
        if (!this.isLockValid()) {
            throw new MediaDeviceLockException("Operation attempted by task other than the device lock owner.", this.mediaDeviceIdentifier.getCurrentLockOwner());
        }
        if (!this.isMediaPresent()) {
            throw new NoMediaPresentException("missing media");
        }
        if (this.isMounted() && this.getFileSystemType() == 1) {
            Trace.trace("XMDADEVF", "USBFlashDrive.getLabel(): The vfat formatted USB flash drive is already mounted, returning the previously found label.");
            Trace.trace("XMDADEVT", "<- USBFlashDrive.getLabel(): returns " + this.volumeLabel);
            return this.volumeLabel;
        }
        Trace.trace("XMDADEVF", "USBFlashDrive.getLabel(): Getting the label for the USB flash memory drive.");
        this.volumeLabel = this.mediaProperties.getLabel(this);
        Trace.trace("XMDADEVF", "USBFlashDrive.getLabel(): volumeLabel = " + this.volumeLabel);
        Trace.trace("XMDADEVT", "<- USBFlashDrive.getLabel(): returns " + this.volumeLabel);
        return this.volumeLabel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String readLabelFile(String labelFile) throws IOException {
        Trace.trace("XMDADEVT", "-> USBFlashDrive.readLabelFile(labelFile = " + labelFile + ")");
        String buffer = null;
        String label = null;
        FileReader tfr = null;
        BufferedReader tbr = null;
        try {
            tfr = new FileReader(labelFile);
            tbr = new BufferedReader(tfr);
            buffer = tbr.readLine();
            if (buffer != null) {
                if (buffer.indexOf("Volume in drive") != -1) {
                    Trace.trace("XMDADEVF", "USBFlashDrive.readLabelFile(): The label file was created with mdir.");
                    if (buffer.indexOf("has no label") == -1) {
                        StringTokenizer st = new StringTokenizer(buffer);
                        int numTokens = st.countTokens();
                        for (int i = 0; i < numTokens - 1; ++i) {
                            String token = st.nextToken();
                        }
                        label = st.nextToken();
                        Trace.trace("XMDADEVF", "USBFlashDrive.readLabelFile(): The label = " + label);
                    } else {
                        Trace.trace("XMDADEVF", "USBFlashDrive.readLabelFile(): The USB flash memory drive has no label.");
                    }
                } else {
                    Trace.trace("XMDADEVF", "USBFlashDrive.readLabelFile(): The label file was created with e2label.");
                    StringTokenizer st = new StringTokenizer(buffer);
                    if (st.hasMoreTokens()) {
                        label = st.nextToken();
                        Trace.trace("XMDADEVF", "USBFlashDrive.readLabelFile(): label = " + label);
                    } else {
                        Trace.trace("XMDADEVF", "USBFlashDrive.readLabelFile(): The USB flash memory drive has no label.");
                    }
                }
            } else {
                Trace.trace("XMDADEVF", "USBFlashDrive.readLabelFile(): buffer == null.");
            }
            Object var11_11 = null;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            try {
                if (tbr != null) {
                    tbr.close();
                }
            }
            catch (IOException ioexc) {
                Trace.trace("XMDADEVF", ioexc);
            }
            throw throwable;
        }
        try {
            if (tbr != null) {
                tbr.close();
            }
        }
        catch (IOException ioexc) {
            Trace.trace("XMDADEVF", ioexc);
        }
        Trace.trace("XMDADEVT", "USBFlashDrive.readLabelFile(): returns " + label);
        return label;
    }

    boolean isMediaPresent() throws MediaDeviceLockException {
        Trace.trace("XMDADEVT", "-> USBFlashDrive.isMediaPresent()");
        if (!this.isLockValid()) {
            throw new MediaDeviceLockException("Operation attempted by task other than the device lock owner.", this.mediaDeviceIdentifier.getCurrentLockOwner());
        }
        int rc = -1;
        try {
            String[] isMediaPresentCmd = new String[]{this.mediaServicesParameters.getParm("media.device.check.media.script"), this.mediaDeviceProperties.getDeviceFile(), new Integer(8).toString(), this.mediaServicesParameters.getParm("media.log.dir") + this.mediaServicesParameters.getParm("media.log")};
            Trace.trace("XMDADEVF", "USBFlashDrive.isMediaPresent(): isMediaPresentCmd[0] = " + isMediaPresentCmd[0]);
            Trace.trace("XMDADEVF", "USBFlashDrive.isMediaPresent(): isMediaPresentCmd[1] = " + isMediaPresentCmd[1]);
            Trace.trace("XMDADEVF", "USBFlashDrive.isMediaPresent(): isMediaPresentCmd[2] = " + isMediaPresentCmd[2]);
            Trace.trace("XMDADEVF", "USBFlashDrive.isMediaPresent(): isMediaPresentCmd[3] = " + isMediaPresentCmd[3]);
            rc = RootProcess.executeProgram(isMediaPresentCmd);
            Trace.trace("XMDADEVF", "USBFlashDrive.isMediaPresent(): rc = " + rc);
        }
        catch (Exception exc) {
            Trace.trace("XMDADEVF", exc);
            MediaDeviceException mdexc = new MediaDeviceException(exc);
            new FrameworkLog(MediaServicesErrorIds._logInfo, 633, mdexc).log();
        }
        if (rc == 0) {
            Trace.trace("XMDADEVF", "USBFlashDrive.isMediaPresent(): The media is present in the device.");
        } else {
            Trace.trace("XMDADEVF", "USBFlashDrive.isMediaPresent(): The media is not present in the device.");
        }
        Trace.trace("XMDADEVT", "<- USBFlashDrive.isMediaPresent()");
        return rc == 0;
    }
}

